<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "rb_kvalif_410";

// Establish connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

session_start();
header('Content-Type: application/json');

// Get the raw input data
$input = json_decode(file_get_contents("php://input"), true);

// Validate the input
if (!isset($input['id'], $input['date'], $input['clock_in_time'], $input['clock_out_time'])) {
    echo json_encode(["error" => "Invalid input. Missing required fields."]);
    exit;
}

$id = intval($input['id']); // Ensure it's an integer
$date = $conn->real_escape_string($input['date']);
$clock_in_time = $conn->real_escape_string($input['clock_in_time']);
$clock_out_time = $conn->real_escape_string($input['clock_out_time']);

// Update the work hours record
$sql = "UPDATE rb_kvalif_workhours_410 
        SET date = ?, 
            clock_in_time = ?, 
            clock_out_time = ?, 
            total_work_hours = IF(clock_out_time IS NOT NULL, TIMESTAMPDIFF(SECOND, CONCAT(date, ' ', clock_in_time), CONCAT(date, ' ', clock_out_time)) / 3600, NULL)
        WHERE id = ?";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode(["error" => "SQL preparation error: " . $conn->error]);
    exit;
}

$stmt->bind_param("sssi", $date, $clock_in_time, $clock_out_time, $id);

if ($stmt->execute()) {
    echo json_encode(["success" => "Record updated successfully."]);
} else {
    echo json_encode(["error" => "Failed to update record: " . $stmt->error]);
}

$stmt->close();
$conn->close();
